/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DoUnlessControllerPaysEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class MegatheriumEffect
extends OneShotEffect {
    MegatheriumEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "sacrifice it unless you pay {1} for each card in your hand";
    }

    private MegatheriumEffect(MegatheriumEffect effect) {
        super((OneShotEffect)effect);
    }

    public MegatheriumEffect copy() {
        return new MegatheriumEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        return new DoUnlessControllerPaysEffect((Effect)new SacrificeSourceEffect(), (Cost)new GenericManaCost(player.getHand().size())).apply(game, source);
    }
}

