/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.StaticHint;
import mage.cards.m.MegatronDestructiveForceReflexiveEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;
import mage.target.common.TargetSacrifice;

class MegatronDestructiveForceEffect
extends OneShotEffect {
    MegatronDestructiveForceEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice another artifact. When you do, {this} deals damage equal to the sacrificed artifact's mana value to target creature. If excess damage would be dealt to that creature this way, instead that damage is dealt to that creature's controller and you convert {this}.";
    }

    private MegatronDestructiveForceEffect(MegatronDestructiveForceEffect effect) {
        super((OneShotEffect)effect);
    }

    public MegatronDestructiveForceEffect copy() {
        return new MegatronDestructiveForceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, 1, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_ARTIFACT);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int manaValue = Math.max(permanent.getManaValue(), 0);
        if (!permanent.sacrifice(source, game)) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new MegatronDestructiveForceReflexiveEffect(manaValue), false);
        ability.addHint((Hint)new StaticHint("Sacrificed artifact mana value: " + manaValue));
        ability.addTarget((Target)new TargetCreaturePermanent());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

