/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;

class MeliraSylvokOutcastEffect
extends ReplacementEffectImpl {
    MeliraSylvokOutcastEffect() {
        super(Duration.WhileOnBattlefield, Outcome.PreventDamage);
        this.staticText = "You can't get poison counters";
    }

    private MeliraSylvokOutcastEffect(MeliraSylvokOutcastEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public MeliraSylvokOutcastEffect copy() {
        return new MeliraSylvokOutcastEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getData().equals(CounterType.POISON.getName()) && event.getTargetId().equals(source.getControllerId());
    }
}

