/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class MeliraSylvokOutcastEffect2
extends ReplacementEffectImpl {
    public MeliraSylvokOutcastEffect2() {
        super(Duration.WhileOnBattlefield, Outcome.PreventDamage);
        this.staticText = "Creatures you control can't have -1/-1 counters put on them";
    }

    private MeliraSylvokOutcastEffect2(MeliraSylvokOutcastEffect2 effect) {
        super((ReplacementEffectImpl)effect);
    }

    public MeliraSylvokOutcastEffect2 copy() {
        return new MeliraSylvokOutcastEffect2(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getData().equals(CounterType.M1M1.getName())) {
            Permanent perm = game.getPermanent(event.getTargetId());
            if (perm == null) {
                perm = game.getPermanentEntering(event.getTargetId());
            }
            return perm != null && perm.isCreature(game) && perm.isControlledBy(source.getControllerId());
        }
        return false;
    }
}

