/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.condition.common.BuybackCondition;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.abilities.keyword.BuybackAbility;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class MemoryCrystalSpellsCostReductionEffect
extends CostModificationEffectImpl {
    MemoryCrystalSpellsCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Buyback costs cost {2} less.";
    }

    private MemoryCrystalSpellsCostReductionEffect(MemoryCrystalSpellsCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Card card = game.getCard(abilityToModify.getSourceId());
        if (card != null) {
            for (Ability ability : card.getAbilities(game)) {
                if (!(ability instanceof BuybackAbility) || !ability.isActivated()) continue;
                int amountToReduce = ((BuybackAbility)ability).reduceCost(2);
                CardUtil.reduceCost((Ability)abilityToModify, (int)amountToReduce);
            }
        }
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (abilityToModify instanceof SpellAbility) {
            return game.getSpell(abilityToModify.getId()) != null && BuybackCondition.instance.apply(game, abilityToModify);
        }
        return false;
    }

    public MemoryCrystalSpellsCostReductionEffect copy() {
        return new MemoryCrystalSpellsCostReductionEffect(this);
    }
}

