/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.common.CollectEvidenceCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MayCastTargetCardEffect;
import mage.constants.CastManaAdjustment;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class MemoryVampireEffect
extends OneShotEffect {
    MemoryVampireEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then you may collect evidence 9. When you do, you may cast target nonland card from defending player's graveyard without paying its mana cost";
    }

    private MemoryVampireEffect(MemoryVampireEffect effect) {
        super((OneShotEffect)effect);
    }

    public MemoryVampireEffect copy() {
        return new MemoryVampireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CollectEvidenceCost cost = new CollectEvidenceCost(9);
        if (!(cost.canPay(source, source, source.getControllerId(), game) && player.chooseUse(this.outcome, "Collect evidence 9?", source, game) && cost.pay(source, game, source, source.getControllerId(), true))) {
            return false;
        }
        UUID defenderId = (UUID)this.getValue("damagedPlayer");
        if (defenderId == null) {
            return true;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new MayCastTargetCardEffect(CastManaAdjustment.WITHOUT_PAYING_MANA_COST), false);
        FilterNonlandCard filter = new FilterNonlandCard("nonland card from defending player's graveyard");
        filter.add((Predicate)new OwnerIdPredicate(defenderId));
        ability.addTarget((Target)new TargetCardInGraveyard((FilterCard)filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

