/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class MemoryVesselPreventionEffect
extends ContinuousRuleModifyingEffectImpl {
    public MemoryVesselPreventionEffect() {
        super(Duration.UntilYourNextTurn, Outcome.Benefit);
        this.staticText = ", and they can't play cards from their hand";
    }

    private MemoryVesselPreventionEffect(MemoryVesselPreventionEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public MemoryVesselPreventionEffect copy() {
        return new MemoryVesselPreventionEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL || event.getType() == GameEvent.EventType.PLAY_LAND;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card = game.getCard(event.getSourceId());
        return card != null && Zone.HAND.match(game.getState().getZone(card.getId()));
    }
}

