/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MercadiasDownfallEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterLandPermanent();

    MercadiasDownfallEffect() {
        super(Outcome.Benefit);
        this.staticText = "each attacking creature gets +1/+0 until end of turn for each nonbasic land defending player controls";
    }

    private MercadiasDownfallEffect(MercadiasDownfallEffect effect) {
        super((OneShotEffect)effect);
    }

    public MercadiasDownfallEffect copy() {
        return new MercadiasDownfallEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_ATTACKING_CREATURE, source.getControllerId(), source, game)) {
            int count = game.getBattlefield().count(filter, game.getCombat().getDefendingPlayerId(permanent.getId(), game), source, game);
            game.addEffect(new BoostTargetEffect(count, 0, Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)SuperType.BASIC.getPredicate()));
    }
}

