/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;
import mage.players.Player;

class MercurialTransformationEffect
extends OneShotEffect {
    MercurialTransformationEffect() {
        super(Outcome.Benefit);
        this.staticText = "until end of turn, target nonland permanent loses all abilities and becomes your choice of a blue Frog creature with base power and toughness 1/1 or a blue Octopus creature with base power and toughness 4/4";
    }

    private MercurialTransformationEffect(MercurialTransformationEffect effect) {
        super((OneShotEffect)effect);
    }

    public MercurialTransformationEffect copy() {
        return new MercurialTransformationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CreatureToken token = player.chooseUse(this.outcome, "1/1 Frog or 4/4 Octopus?", null, "Frog", "Octopus", source, game) ? new CreatureToken(1, 1).withColor("U").withSubType(SubType.FROG) : new CreatureToken(4, 4).withColor("U").withSubType(SubType.OCTOPUS);
        game.addEffect((ContinuousEffect)new BecomesCreatureTargetEffect((Token)token, true, false, Duration.EndOfTurn).withDurationRuleAtStart(true), source);
        return true;
    }
}

