/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class MerfolkSpyEffect
extends OneShotEffect {
    MerfolkSpyEffect() {
        super(Outcome.Detriment);
        this.staticText = "that player reveals a card at random from their hand";
    }

    private MerfolkSpyEffect(MerfolkSpyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null && !player.getHand().isEmpty()) {
            CardsImpl revealed = new CardsImpl();
            revealed.add(player.getHand().getRandom(game));
            player.revealCards("Merfolk Spy", (Cards)revealed, game);
            return true;
        }
        return false;
    }

    public MerfolkSpyEffect copy() {
        return new MerfolkSpyEffect(this);
    }
}

