/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.ActivatedAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.cards.m.MerseineCost;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MerseineActivatedAbility
extends SimpleActivatedAbility {
    public MerseineActivatedAbility() {
        super(Zone.BATTLEFIELD, (Effect)new RemoveCounterSourceEffect(CounterType.NET.createInstance()), (Cost)new MerseineCost());
    }

    private MerseineActivatedAbility(MerseineActivatedAbility ability) {
        super((SimpleActivatedAbility)ability);
    }

    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Permanent attachedTo;
        Permanent sourcePermanent = game.getPermanent(this.getSourceId());
        if (sourcePermanent != null && (attachedTo = game.getPermanent(sourcePermanent.getAttachedTo())) != null) {
            return super.canActivate(attachedTo.getControllerId(), game);
        }
        return ActivatedAbility.ActivationStatus.getFalse();
    }

    public MerseineActivatedAbility copy() {
        return new MerseineActivatedAbility(this);
    }

    public String getRule() {
        return "Pay enchanted creature's mana cost: Remove a net counter from {this}. Only the controller of the enchanted creature may activate this ability.";
    }
}

