/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class MetallicMimicReplacementEffect
extends ReplacementEffectImpl {
    MetallicMimicReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "Each other creature you control of the chosen type enters the battlefield with an additional +1/+1 counter on it";
        this.setCharacterDefining(true);
    }

    private MetallicMimicReplacementEffect(MetallicMimicReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Permanent enteringCreature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (enteringCreature != null && sourcePermanent != null && enteringCreature.isControlledBy(source.getControllerId()) && enteringCreature.isCreature(game) && !event.getTargetId().equals(source.getSourceId())) {
            SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game);
            return subType != null && enteringCreature.hasSubtype(subType, game);
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (creature != null) {
            creature.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game, event.getAppliedEffects());
        }
        return false;
    }

    public MetallicMimicReplacementEffect copy() {
        return new MetallicMimicReplacementEffect(this);
    }
}

