/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class MetalworkerManaEffect
extends ManaEffect {
    MetalworkerManaEffect() {
        this.staticText = "Reveal any number of artifact cards in your hand. Add {C}{C} for each card revealed this way";
    }

    private MetalworkerManaEffect(MetalworkerManaEffect effect) {
        super((ManaEffect)effect);
    }

    public MetalworkerManaEffect copy() {
        return new MetalworkerManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        int artifacts;
        Player controller;
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game != null && (controller = this.getPlayer(game, source)) != null && (artifacts = controller.getHand().count((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT, game)) > 0) {
            netMana.add(Mana.ColorlessMana((int)(artifacts * 2)));
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        TargetCardInHand target;
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Player controller = this.getPlayer(game, source);
        if (controller == null) {
            return mana;
        }
        int artifacts = controller.getHand().count((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT, game);
        if (artifacts > 0 && controller.choose(Outcome.Benefit, (Target)(target = new TargetCardInHand(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARD_ARTIFACT)), source, game)) {
            CardsImpl cards = new CardsImpl((Collection)target.getTargets());
            controller.revealCards(source, (Cards)cards, game);
            return Mana.ColorlessMana((int)(target.getTargets().size() * 2));
        }
        return mana;
    }
}

