/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PutCardFromHandOntoBattlefieldEffect;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class MetathranAerostatEffect
extends OneShotEffect {
    MetathranAerostatEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may put a creature card with mana value X from your hand onto the battlefield. If you do, return {this} to its owner's hand";
    }

    private MetathranAerostatEffect(MetathranAerostatEffect effect) {
        super((OneShotEffect)effect);
    }

    public MetathranAerostatEffect copy() {
        return new MetathranAerostatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        FilterCreatureCard filter = new FilterCreatureCard("a creature with mana value " + xValue);
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, xValue));
        if (new PutCardFromHandOntoBattlefieldEffect((FilterCard)filter).apply(game, source)) {
            return new ReturnToHandSourceEffect(true).apply(game, source);
        }
        return false;
    }
}

