/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

class MiasmaDemonEffect
extends OneShotEffect {
    MiasmaDemonEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may discard any number of cards. When you do, up to that many target creatures each get -2/-2 until end of turn";
    }

    private MiasmaDemonEffect(MiasmaDemonEffect effect) {
        super((OneShotEffect)effect);
    }

    public MiasmaDemonEffect copy() {
        return new MiasmaDemonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int amount = player.discard(0, Integer.MAX_VALUE, false, source, game).size();
        if (amount < 1) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new BoostTargetEffect(-2, -2), false, "Up to that many target creatures each get -2/-2 until end of turn");
        ability.addTarget((Target)new TargetCreaturePermanent(0, amount));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

