/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersAllEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.combat.Combat;
import mage.game.events.GameEvent;

class MilaCraftyCompanionTriggeredAbility
extends TriggeredAbilityImpl {
    MilaCraftyCompanionTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersAllEffect(CounterType.LOYALTY.createInstance(), (FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_PLANESWALKER), false);
    }

    private MilaCraftyCompanionTriggeredAbility(MilaCraftyCompanionTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MilaCraftyCompanionTriggeredAbility copy() {
        return new MilaCraftyCompanionTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return game.getCombat().getAttackers().stream().filter(attackerId -> game.getOpponents(this.getControllerId()).contains(game.getControllerId(attackerId))).map(arg_0 -> ((Combat)game.getCombat()).getDefenderId(arg_0)).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(permanent -> permanent.isPlaneswalker(game)).map(Controllable::getControllerId).anyMatch(this.getControllerId()::equals);
    }

    public String getRule() {
        return "Whenever an opponent attacks one or more planeswalkers you control, put a loyalty counter on each planeswalker you control.";
    }
}

