/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class MinasTirithGarrisonEffect
extends OneShotEffect {
    static final FilterControlledPermanent filter = new FilterControlledPermanent(SubType.HUMAN, "untapped Humans you control");

    public MinasTirithGarrisonEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "tap any number of untapped Humans you control. Draw a card for each Human tapped this way";
    }

    private MinasTirithGarrisonEffect(MinasTirithGarrisonEffect effect) {
        super((OneShotEffect)effect);
    }

    public MinasTirithGarrisonEffect copy() {
        return new MinasTirithGarrisonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetControlledPermanent target = new TargetControlledPermanent(0, Integer.MAX_VALUE, filter, true);
        controller.choose(this.outcome, (Target)target, source, game);
        if (target.getTargets().isEmpty()) {
            return false;
        }
        int tappedAmount = 0;
        for (UUID permanentId : target.getTargets()) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null || !permanent.tap(source, game)) continue;
            ++tappedAmount;
        }
        return new DrawCardSourceControllerEffect(tappedAmount).apply(game, source);
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

