/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class MindleechGhoulEffect
extends OneShotEffect {
    MindleechGhoulEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent exiles a card from their hand";
    }

    private MindleechGhoulEffect(MindleechGhoulEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindleechGhoulEffect copy() {
        return new MindleechGhoulEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null || opponent.getHand().isEmpty()) continue;
            TargetCardInHand target = new TargetCardInHand();
            opponent.choose(Outcome.Discard, opponent.getHand(), (TargetCard)target, source, game);
            cards.add(game.getCard(target.getFirstTarget()));
        }
        return controller.moveCards((Cards)cards, Zone.EXILED, source, game);
    }
}

