/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CastManaAdjustment;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class MindleecherEffect
extends OneShotEffect {
    MindleecherEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of each opponent's library face down. You may look at and play those cards for as long as they remain exiled.";
    }

    private MindleecherEffect(MindleecherEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindleecherEffect copy() {
        return new MindleecherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        game.getOpponents(controller.getId()).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(Player::getLibrary).map(library -> library.getFromTop(game)).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        if (cards.isEmpty()) {
            return false;
        }
        return new ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect(false, CastManaAdjustment.NONE).setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game)).apply(game, source);
    }
}

