/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.m.MindlinkMechEffect;
import mage.cards.m.MindlinkMechWatcher;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.CrewedSourceThisTurnPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.TargetPermanent;

class MindlinkMechTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("nonlegendary creature that crewed it this turn");

    MindlinkMechTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new MindlinkMechEffect());
        this.addWatcher(new MindlinkMechWatcher());
        this.addTarget((Target)new TargetPermanent(filter));
        this.setTriggerPhrase("Whenever {this} becomes crewed for the first time each turn");
    }

    private MindlinkMechTriggeredAbility(MindlinkMechTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MindlinkMechTriggeredAbility copy() {
        return new MindlinkMechTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.VEHICLE_CREWED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getSourceId().equals(this.getSourceId()) && MindlinkMechWatcher.checkVehicle((Ability)this, game);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)CrewedSourceThisTurnPredicate.instance);
        filter.add(Predicates.not((Predicate)SuperType.LEGENDARY.getPredicate()));
    }
}

