/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;

class MindsDesireEffect
extends OneShotEffect {
    MindsDesireEffect() {
        super(Outcome.Benefit);
        this.staticText = "Shuffle your library. Then exile the top card of your library. Until end of turn, you may play that card without paying its mana cost";
    }

    private MindsDesireEffect(MindsDesireEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindsDesireEffect copy() {
        return new MindsDesireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.shuffleLibrary(source, game);
            return PlayFromNotOwnHandZoneTargetEffect.exileAndPlayFromExile((Game)game, (Ability)source, (Card)controller.getLibrary().getFromTop(game), (TargetController)TargetController.YOU, (Duration)Duration.EndOfTurn, (boolean)true, (boolean)false, (boolean)false);
        }
        return false;
    }
}

