/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.watchers.Watcher;

class MindstormCrownWatcher
extends Watcher {
    private int cardsInHandCount;

    public MindstormCrownWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.BEGINNING_PHASE_PRE && game.getPhase() != null) {
            Player player = game.getPlayer(game.getActivePlayerId());
            int cardsInHand = 0;
            if (player != null) {
                cardsInHand = player.getHand().size();
            }
            this.cardsInHandCount = cardsInHand;
        }
    }

    public int getCardsInHandCount() {
        return this.cardsInHandCount;
    }

    public void reset() {
        this.cardsInHandCount = 0;
    }
}

