/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.BecomesTappedTriggeredAbility;
import mage.abilities.common.LeavesBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.RemoveAllCountersAllEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.target.Target;
import mage.target.common.TargetLandPermanent;

public final class MineLayer
extends CardImpl {
    private static final FilterLandPermanent filter = new FilterLandPermanent("land with a mine counter on it");

    public MineLayer(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{3}{R}");
        this.subtype.add((Object)SubType.DWARF);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new AddCountersTargetEffect(CounterType.MINE.createInstance()), (Cost)new TapSourceCost());
        ability.addCost((Cost)new ManaCostsImpl("{1}{R}"));
        ability.addTarget((Target)new TargetLandPermanent());
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new BecomesTappedTriggeredAbility((Effect)new DestroyTargetEffect().setText("destroy it"), false, (FilterPermanent)filter, true));
        this.addAbility((Ability)new LeavesBattlefieldTriggeredAbility((Effect)new RemoveAllCountersAllEffect(CounterType.MINE, (FilterPermanent)StaticFilters.FILTER_LANDS), false));
    }

    private MineLayer(MineLayer card) {
        super((CardImpl)card);
    }

    public MineLayer copy() {
        return new MineLayer(this);
    }

    static {
        filter.add((Predicate)CounterType.MINE.getPredicate());
    }
}

