/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MineMineMineDrawEffect
extends OneShotEffect {
    MineMineMineDrawEffect() {
        super(Outcome.DrawCard);
        this.staticText = "each player puts their library into their hand";
    }

    private MineMineMineDrawEffect(MineMineMineDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            CardsImpl libraryCards = new CardsImpl();
            libraryCards.addAllCards((Collection)player.getLibrary().getCards(game));
            player.moveCards((Cards)libraryCards, Zone.HAND, source, game);
        }
        return true;
    }

    public MineMineMineDrawEffect copy() {
        return new MineMineMineDrawEffect(this);
    }
}

