/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MirkoVoskMindDrinkerEffect
extends OneShotEffect {
    MirkoVoskMindDrinkerEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player reveals cards from the top of their library until they reveal four land cards, then puts those cards into their graveyard";
    }

    private MirkoVoskMindDrinkerEffect(MirkoVoskMindDrinkerEffect effect) {
        super((OneShotEffect)effect);
    }

    public MirkoVoskMindDrinkerEffect copy() {
        return new MirkoVoskMindDrinkerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        int landsToReveal = 4;
        CardsImpl cards = new CardsImpl();
        for (Card card : player.getLibrary().getCards(game)) {
            if (card == null) continue;
            cards.add(card);
            if (!card.isLand(game) || --landsToReveal >= 1) continue;
            break;
        }
        player.revealCards(source, "from " + player.getName(), (Cards)cards, game);
        player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        return true;
    }
}

