/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MirriWeatherlightDuelistBlockRestrictionEffect
extends RestrictionEffect {
    MirriWeatherlightDuelistBlockRestrictionEffect() {
        super(Duration.EndOfCombat);
        this.staticText = "each opponent can't block with more than one creature this combat";
    }

    private MirriWeatherlightDuelistBlockRestrictionEffect(MirriWeatherlightDuelistBlockRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public MirriWeatherlightDuelistBlockRestrictionEffect copy() {
        return new MirriWeatherlightDuelistBlockRestrictionEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return true;
    }

    public boolean canBlock(Permanent attacker, Permanent newBlocker, Ability source, Game game, boolean canUseChooseDialogs) {
        if (attacker == null) {
            return true;
        }
        Player controller = game.getPlayer(attacker.getControllerId());
        if (controller == null) {
            return true;
        }
        for (UUID existingBlockerId : game.getCombat().getBlockers()) {
            Permanent existingBlocker = game.getPermanent(existingBlockerId);
            if (existingBlocker == null || !controller.hasOpponent(existingBlocker.getControllerId(), game) || !existingBlocker.isControlledBy(newBlocker.getControllerId())) continue;
            return false;
        }
        return true;
    }
}

