/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawDiscardControllerEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class MirrodinBesiegedEffect
extends OneShotEffect {
    MirrodinBesiegedEffect() {
        super(Outcome.Benefit);
        this.setText("draw a card, then discard a card. Then if there are fifteen or more artifact cards in your graveyard, target opponent loses the game.");
    }

    private MirrodinBesiegedEffect(MirrodinBesiegedEffect effect) {
        super((OneShotEffect)effect);
    }

    public MirrodinBesiegedEffect copy() {
        return new MirrodinBesiegedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        new DrawDiscardControllerEffect(1, 1).apply(game, source);
        Player player = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (player == null || opponent == null) {
            return false;
        }
        if (player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT, source.getControllerId(), source, game).size() >= 15) {
            opponent.lost(game);
        }
        return true;
    }
}

