/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ProtectionAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class MirrorGolemEffect
extends ContinuousEffectImpl {
    MirrorGolemEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.addDependedToType(DependencyType.AddingAbility);
        this.staticText = "{this} has protection from each of the exiled card's card types.";
    }

    private MirrorGolemEffect(MirrorGolemEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        if (sourceObject == null || sourceObject.getImprinted() == null) {
            return false;
        }
        UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)sourceObject.getZoneChangeCounter(game));
        ExileZone exileZone = game.getExile().getExileZone(exileZoneId);
        if (exileZone == null) {
            return false;
        }
        for (UUID imprinted : sourceObject.getImprinted()) {
            Card card;
            if (imprinted == null || !exileZone.contains((Object)imprinted) || (card = game.getCard(imprinted)) == null) continue;
            for (CardType cardType : card.getCardType(game)) {
                FilterCard filterCard = cardType.equals((Object)CardType.SORCERY) ? new FilterCard("sorceries") : (cardType.equals((Object)CardType.KINDRED) ? new FilterCard("kindred") : new FilterCard(cardType.toString() + "s"));
                filterCard.add((Predicate)cardType.getPredicate());
                sourceObject.addAbility((Ability)new ProtectionAbility((Filter)filterCard), source.getSourceId(), game);
            }
        }
        return true;
    }

    public MirrorGolemEffect copy() {
        return new MirrorGolemEffect(this);
    }
}

