/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MirrorMadPhantasmEffect
extends OneShotEffect {
    MirrorMadPhantasmEffect() {
        super(Outcome.Detriment);
        this.staticText = "{this}'s owner shuffles it into their library. If that player does, they reveal cards from the top of that library until a card named Mirror-Mad Phantasm is revealed. That player puts that card onto the battlefield and all other cards revealed this way into their graveyard";
    }

    private MirrorMadPhantasmEffect(MirrorMadPhantasmEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent perm = source.getSourcePermanentIfItStillExists(game);
        if (perm != null) {
            Player owner = game.getPlayer(perm.getOwnerId());
            if (owner == null) {
                return false;
            }
            if (owner.shuffleCardsToLibrary((Card)perm, game, source)) {
                CardsImpl cards = new CardsImpl();
                Card phantasmCard = null;
                for (Card card : owner.getLibrary().getCards(game)) {
                    cards.add(card);
                    if (!card.getName().equals("Mirror-Mad Phantasm")) continue;
                    phantasmCard = card;
                    break;
                }
                owner.revealCards(source, (Cards)cards, game);
                if (phantasmCard != null) {
                    owner.moveCards(phantasmCard, Zone.BATTLEFIELD, source, game);
                    cards.remove(phantasmCard);
                }
                owner.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
            }
        }
        return true;
    }

    public MirrorMadPhantasmEffect copy() {
        return new MirrorMadPhantasmEffect(this);
    }
}

