/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MirrorMockeryEffect
extends OneShotEffect {
    MirrorMockeryEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may create a token that's a copy of that creature. Exile that token at end of combat";
    }

    private MirrorMockeryEffect(MirrorMockeryEffect effect) {
        super((OneShotEffect)effect);
    }

    public MirrorMockeryEffect copy() {
        return new MirrorMockeryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantment = source.getSourcePermanentOrLKI(game);
        if (enchantment == null) {
            return false;
        }
        Permanent enchanted = game.getPermanentOrLKIBattlefield(enchantment.getAttachedTo());
        if (enchanted != null) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(enchanted, game));
            effect.apply(game, source);
            for (Permanent addedToken : effect.getAddedPermanents()) {
                if (addedToken == null) continue;
                ExileTargetEffect exileEffect = new ExileTargetEffect();
                exileEffect.setTargetPointer((TargetPointer)new FixedTarget(addedToken, game));
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheEndOfCombatDelayedTriggeredAbility((Effect)exileEffect), source);
            }
            return true;
        }
        return false;
    }
}

