/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.cards.m.FaceUpPredicate;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.ExileZone;
import mage.game.Game;
import mage.target.common.TargetCardInExile;

class MirrorOfFateTarget
extends TargetCardInExile {
    public MirrorOfFateTarget() {
        super(0, 7, new FilterCard());
        this.filter.add((Predicate)new FaceUpPredicate());
        this.targetName = "face-up exiled cards you own";
    }

    private MirrorOfFateTarget(MirrorOfFateTarget target) {
        super((TargetCardInExile)target);
    }

    public boolean canTarget(UUID id, Ability source, Game game) {
        Card card = game.getCard(id);
        if (card != null && card.isOwnedBy(source.getControllerId()) && game.getState().getZone(card.getId()) == Zone.EXILED) {
            for (ExileZone exile : game.getExile().getExileZones()) {
                if (exile == null || !exile.contains((Object)id)) continue;
                return this.filter.match(card, source.getControllerId(), source, game);
            }
        }
        return false;
    }

    public MirrorOfFateTarget copy() {
        return new MirrorOfFateTarget(this);
    }
}

