/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class MirrorOfLifeTrappingEffect
extends OneShotEffect {
    MirrorOfLifeTrappingEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile it, then return all other permanent cards exiled with {this} to the battlefield under their owners' control";
    }

    private MirrorOfLifeTrappingEffect(MirrorOfLifeTrappingEffect effect) {
        super((OneShotEffect)effect);
    }

    public MirrorOfLifeTrappingEffect copy() {
        return new MirrorOfLifeTrappingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
        ExileZone exileZone = game.getExile().getExileZone(exileZoneId);
        CardsImpl toBattlefield = null;
        if (exileZone != null && !exileZone.isEmpty()) {
            toBattlefield = new CardsImpl((Collection)exileZone);
        }
        if ((permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null) {
            controller.moveCardsToExile((Card)permanent, source, game, true, exileZoneId, sourceObject.getIdName());
        }
        if (toBattlefield != null) {
            game.processAction();
            controller.moveCards(toBattlefield.getCards((FilterCard)StaticFilters.FILTER_CARD_PERMANENT, game), Zone.BATTLEFIELD, source, game, false, false, true, null);
        }
        return true;
    }
}

