/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MisfortuneEffect
extends OneShotEffect {
    MisfortuneEffect() {
        super(Outcome.Benefit);
        this.staticText = "you put a -1/-1 counter on each creature that player controls and {this} deals 4 damage to that player";
    }

    private MisfortuneEffect(MisfortuneEffect effect) {
        super((OneShotEffect)effect);
    }

    public MisfortuneEffect copy() {
        return new MisfortuneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer((UUID)this.getValue("choosingPlayer"));
        if (player == null) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player.getId(), source, game)) {
            permanent.addCounters(CounterType.M1M1.createInstance(), source.getControllerId(), source, game);
        }
        player.damage(4, source, game);
        return true;
    }
}

