/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.m.MisfortuneTellerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;

class MisfortuneTellerTriggeredAbility
extends TriggeredAbilityImpl {
    public MisfortuneTellerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new MisfortuneTellerEffect());
        this.setTriggerPhrase("Whenever {this} enters or deals combat damage to a player, ");
    }

    private MisfortuneTellerTriggeredAbility(MisfortuneTellerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MisfortuneTellerTriggeredAbility copy() {
        return new MisfortuneTellerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            return event.getTargetId().equals(this.sourceId);
        }
        if (event.getType() == GameEvent.EventType.DAMAGED_PLAYER) {
            return event.getSourceId().equals(this.sourceId) && ((DamagedEvent)event).isCombatDamage();
        }
        return false;
    }
}

