/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class MisinformationEffect
extends OneShotEffect {
    MisinformationEffect() {
        super(Outcome.Detriment);
        this.staticText = "Put up to three target cards from an opponent's graveyard on top of their library in any order";
    }

    private MisinformationEffect(MisinformationEffect effect) {
        super((OneShotEffect)effect);
    }

    public MisinformationEffect copy() {
        return new MisinformationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List targets;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (targets = this.getTargetPointer().getTargets(game, source)) != null) {
            CardsImpl cards = new CardsImpl((Collection)targets);
            controller.putCardsOnTopOfLibrary((Cards)cards, game, source, true);
            return true;
        }
        return false;
    }
}

