/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MissDemeanorEffect
extends OneShotEffect {
    MissDemeanorEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "you may compliment that player on their game play. If you don't, sacrifice {this}";
    }

    private MissDemeanorEffect(MissDemeanorEffect effect) {
        super((OneShotEffect)effect);
    }

    public MissDemeanorEffect copy() {
        return new MissDemeanorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourceObject = source.getSourcePermanentIfItStillExists(game);
        String activePlayerName = game.getPlayer(game.getActivePlayerId()).getName();
        if (sourceObject != null) {
            if (controller.chooseUse(this.outcome, "Compliment " + activePlayerName + " on their game play?", source, game)) {
                game.informPlayers(controller.getLogName() + ": That's a well-built deck and you pilot it well, " + activePlayerName + ".");
            } else {
                sourceObject.sacrifice(source, game);
            }
            return true;
        }
        return false;
    }
}

