/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class MisterNegativeEffect
extends OneShotEffect {
    MisterNegativeEffect() {
        super(Outcome.Neutral);
        this.staticText = "When {this} enters, you may exchange your life total with target opponent. If you lose life this way, draw that many cards.";
    }

    protected MisterNegativeEffect(MisterNegativeEffect effect) {
        super((OneShotEffect)effect);
    }

    public MisterNegativeEffect copy() {
        return new MisterNegativeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null) {
            return false;
        }
        int startingLife = controller.getLife();
        controller.exchangeLife(player, source, game);
        int lifeChange = startingLife - controller.getLife();
        if (lifeChange > 0) {
            controller.drawCards(lifeChange, source, game);
        }
        return true;
    }
}

