/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeTargetEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MistformSliverEffect
extends OneShotEffect {
    MistformSliverEffect() {
        super(Outcome.Benefit);
        this.staticText = "This permanent becomes the creature type of your choice in addition to its other types until end of turn";
    }

    private MistformSliverEffect(MistformSliverEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (player != null && permanent != null) {
            ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
            if (!player.choose(Outcome.Detriment, (Choice)typeChoice, game)) {
                return false;
            }
            game.informPlayers(permanent.getName() + ": " + player.getLogName() + " has chosen " + typeChoice.getChoiceKey());
            AddCardSubTypeTargetEffect effect = new AddCardSubTypeTargetEffect(SubType.byDescription((String)typeChoice.getChoiceKey()), Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return false;
    }

    public MistformSliverEffect copy() {
        return new MistformSliverEffect(this);
    }
}

