/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.common.CantBeCounteredSourceAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.watchers.common.SpellsCastWatcher;

class MistriseCantBeCounteredEffect
extends ContinuousEffectImpl {
    private int spellsCastThisTurn;

    public MistriseCantBeCounteredEffect() {
        super(Duration.EndOfTurn, Layer.RulesEffects, SubLayer.NA, Outcome.Benefit);
        this.staticText = "the next spell you cast this turn can't be countered";
    }

    protected MistriseCantBeCounteredEffect(MistriseCantBeCounteredEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.spellsCastThisTurn = effect.spellsCastThisTurn;
    }

    public MistriseCantBeCounteredEffect copy() {
        return new MistriseCantBeCounteredEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        if (watcher != null) {
            this.spellsCastThisTurn = watcher.getSpellsCastThisTurn(source.getControllerId()).size();
        }
    }

    public boolean apply(Game game, Ability source) {
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        if (watcher == null) {
            return false;
        }
        if (game.getStack().isEmpty() && watcher.getSpellsCastThisTurn(source.getControllerId()).size() >= this.spellsCastThisTurn + 1) {
            this.discard();
            return false;
        }
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell) || !stackObject.isControlledBy(source.getControllerId())) continue;
            Spell spell = (Spell)stackObject;
            List spellsCast = watcher.getSpellsCastThisTurn(source.getControllerId());
            for (int i = 0; i < spellsCast.size(); ++i) {
                if (i != this.spellsCastThisTurn || !((Spell)spellsCast.get(i)).getId().equals(spell.getId())) continue;
                game.getState().addOtherAbility(spell.getCard(), (Ability)new CantBeCounteredSourceAbility());
                return true;
            }
        }
        return false;
    }
}

