/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;

class MitoticManipulationEffect
extends OneShotEffect {
    MitoticManipulationEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Look at the top seven cards of your library. You may put one of those cards onto the battlefield if it has the same name as a permanent. Put the rest on the bottom of your library in any order";
    }

    private MitoticManipulationEffect(MitoticManipulationEffect effect) {
        super((OneShotEffect)effect);
    }

    public MitoticManipulationEffect copy() {
        return new MitoticManipulationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            HashSet<String> permanentNames = new HashSet<String>();
            for (Permanent permanent : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
                permanentNames.add(permanent.getName());
            }
            CardsImpl cardsFromTop = new CardsImpl();
            cardsFromTop.addAllCards((Collection)controller.getLibrary().getTopCards(game, 7));
            controller.lookAtCards(sourceObject.getIdName(), (Cards)cardsFromTop, game);
            FilterCard filter = new FilterCard("card to put onto the battlefield");
            ArrayList<NamePredicate> namePredicates = new ArrayList<NamePredicate>();
            for (String name : permanentNames) {
                namePredicates.add(new NamePredicate(name));
            }
            if (!namePredicates.isEmpty() && !cardsFromTop.isEmpty()) {
                Card card;
                filter.add(Predicates.or(namePredicates));
                TargetCard target = new TargetCard(Zone.LIBRARY, filter);
                if (cardsFromTop.count(filter, source.getControllerId(), source, game) > 0 && controller.chooseUse(Outcome.PutCardInPlay, "Put a card on the battlefield?", source, game) && controller.choose(Outcome.PutCardInPlay, (Cards)cardsFromTop, target, source, game) && (card = cardsFromTop.get(target.getFirstTarget(), game)) != null) {
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                    cardsFromTop.remove(card);
                }
            }
            controller.putCardsOnBottomOfLibrary((Cards)cardsFromTop, game, source, true);
            return true;
        }
        return false;
    }
}

