/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.m.MnemonicBetrayalDelayedTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class MnemonicBetrayalExileEffect
extends OneShotEffect {
    MnemonicBetrayalExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile all opponents' graveyards. You may cast spells from among those cards this turn, and you may spend mana as though it were mana of any type to cast those spells. At the beginning of the next end step, if any of those cards remain exiled, return them to their owners' graveyards";
    }

    private MnemonicBetrayalExileEffect(MnemonicBetrayalExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public MnemonicBetrayalExileEffect copy() {
        return new MnemonicBetrayalExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        game.getOpponents(source.getControllerId(), true).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getGraveyard).map(g -> g.getCards(game)).forEach(arg_0 -> ((Cards)cards).addAllCards(arg_0));
        controller.moveCardsToExile(cards.getCards(game), source, game, true, source.getSourceId(), CardUtil.getSourceName((Game)game, (Ability)source));
        for (Card card : cards.getCards(game)) {
            if (card.isLand(game)) continue;
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.EndOfTurn, (boolean)true);
        }
        cards.retainZone(Zone.EXILED, game);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new MnemonicBetrayalDelayedTriggeredAbility(cards.stream().map(uuid -> new MageObjectReference(uuid, game)).collect(Collectors.toSet())), source);
        return true;
    }
}

