/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MobileHomesteadEffect
extends OneShotEffect {
    MobileHomesteadEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. If it's a land card, you may put it onto the battlefield tapped";
    }

    private MobileHomesteadEffect(MobileHomesteadEffect effect) {
        super((OneShotEffect)effect);
    }

    public MobileHomesteadEffect copy() {
        return new MobileHomesteadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return true;
        }
        controller.lookAtCards(sourceObject.getIdName(), (Cards)new CardsImpl(card), game);
        if (!card.isLand(game)) {
            return true;
        }
        String message = "Put " + card.getLogName() + " onto the battlefield tapped?";
        if (controller.chooseUse(Outcome.PutLandInPlay, message, source, game)) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        }
        return true;
    }
}

