/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenTargetEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.GoblinToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class MoggInfestationEffect
extends OneShotEffect {
    MoggInfestationEffect() {
        super(Outcome.Detriment);
        this.staticText = "Destroy all creatures target player controls. For each creature that died this way, create two 1/1 red Goblin creature tokens under that player's control";
    }

    private MoggInfestationEffect(MoggInfestationEffect effect) {
        super((OneShotEffect)effect);
    }

    public MoggInfestationEffect copy() {
        return new MoggInfestationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        HashSet<UUID> creaturesDied = new HashSet<UUID>();
        if (controller != null && this.getTargetPointer().getFirst(game, source) != null) {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, this.getTargetPointer().getFirst(game, source), game)) {
                if (!permanent.destroy(source, game, false) || game.getState().getZone(permanent.getId()) != Zone.GRAVEYARD && (!(permanent instanceof PermanentToken) || game.getBattlefield().containsPermanent(permanent.getId()))) continue;
                creaturesDied.add(permanent.getId());
            }
            if (creaturesDied.isEmpty()) {
                return true;
            }
            game.processAction();
            for (UUID uuid : creaturesDied) {
                if (game.getState().getZone(uuid) != Zone.GRAVEYARD && (!(game.getLastKnownInformation(uuid, Zone.BATTLEFIELD) instanceof PermanentToken) || game.getBattlefield().containsPermanent(uuid))) continue;
                CreateTokenTargetEffect effect = new CreateTokenTargetEffect((Token)new GoblinToken(), 2);
                effect.setTargetPointer(this.getTargetPointer().copy());
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

