/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MoggToadyCantBlockEffect
extends RestrictionEffect {
    MoggToadyCantBlockEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't block unless you control more creatures than attacking player";
    }

    private MoggToadyCantBlockEffect(MoggToadyCantBlockEffect effect) {
        super((RestrictionEffect)effect);
    }

    public MoggToadyCantBlockEffect copy() {
        return new MoggToadyCantBlockEffect(this);
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        if (attacker == null) {
            return true;
        }
        UUID attackingPlayerId = attacker.getControllerId();
        if (attackingPlayerId != null) {
            return game.getBattlefield().countAll((FilterPermanent)new FilterControlledCreaturePermanent(), source.getControllerId(), game) > game.getBattlefield().countAll((FilterPermanent)new FilterControlledCreaturePermanent(), attackingPlayerId, game);
        }
        return true;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }
}

