/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class MolderBeastTriggeredAbility
extends TriggeredAbilityImpl {
    public MolderBeastTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BoostSourceEffect(2, 0, Duration.EndOfTurn), false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private MolderBeastTriggeredAbility(MolderBeastTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.isDiesEvent() && zEvent.getTarget().isArtifact(game);
    }

    public String getRule() {
        return "Whenever an artifact is put into a graveyard from the battlefield, {this} gets +2/+0 until end of turn.";
    }

    public MolderBeastTriggeredAbility copy() {
        return new MolderBeastTriggeredAbility(this);
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

