/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class MoltenInfluenceEffect
extends OneShotEffect {
    MoltenInfluenceEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target instant or sorcery spell unless its controller has {this} deal 4 damage to them";
    }

    private MoltenInfluenceEffect(MoltenInfluenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public MoltenInfluenceEffect copy() {
        return new MoltenInfluenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(source.getFirstTarget());
        if (spell != null) {
            Player player = game.getPlayer(spell.getControllerId());
            String message = "Have Molten Influence do 4 damage to you?";
            if (player != null && player.chooseUse(Outcome.Damage, message, source, game)) {
                player.damage(4, source.getSourceId(), source, game);
                return true;
            }
            return game.getStack().counter(source.getFirstTarget(), source, game);
        }
        return false;
    }
}

