/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class MomentOfTruthEffect
extends OneShotEffect {
    MomentOfTruthEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top three cards of your library. Put one of those cards into your hand, one into your graveyard, and one on the bottom of your library";
    }

    private MomentOfTruthEffect(MomentOfTruthEffect effect) {
        super((OneShotEffect)effect);
    }

    public MomentOfTruthEffect copy() {
        return new MomentOfTruthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 3));
        if (cards.size() < 1) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(cards.size() == 3 ? 1 : 0, 1, StaticFilters.FILTER_CARD);
        target.withChooseHint("To put into your hand");
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            player.moveCards(card, Zone.HAND, source, game);
            cards.remove(card);
        }
        if (cards.isEmpty()) {
            return true;
        }
        target = new TargetCardInLibrary(cards.size() == 2 ? 1 : 0, 1, StaticFilters.FILTER_CARD);
        target.withChooseHint("To put into your graveyard");
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        card = game.getCard(target.getFirstTarget());
        if (card != null) {
            player.putInGraveyard(card, game);
            cards.remove(card);
        }
        if (cards.isEmpty()) {
            return true;
        }
        target = new TargetCardInLibrary();
        target.withChooseHint("To put on the bottom of your library");
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return true;
        }
        player.putCardsOnBottomOfLibrary(card, game, source);
        return true;
    }
}

