/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

public final class MomentOfValor
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creature with power 4 or greater");

    public MomentOfValor(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{2}{W}");
        this.getSpellAbility().addEffect((Effect)new UntapTargetEffect());
        this.getSpellAbility().addEffect((Effect)new BoostTargetEffect(1, 0).setText("It gets +1/+0"));
        this.getSpellAbility().addEffect((Effect)new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance()).setText("and gains indestructible until end of turn"));
        this.getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
        Mode mode = new Mode((Effect)new DestroyTargetEffect());
        mode.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        this.getSpellAbility().addMode(mode);
    }

    private MomentOfValor(MomentOfValor card) {
        super((CardImpl)card);
    }

    public MomentOfValor copy() {
        return new MomentOfValor(this);
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.OR_GREATER, 4));
    }
}

