/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MomentousFallEffect
extends OneShotEffect {
    MomentousFallEffect() {
        super(Outcome.GainLife);
        this.staticText = "You draw cards equal to the sacrificed creature's power, then you gain life equal to its toughness";
    }

    private MomentousFallEffect(MomentousFallEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int power = 0;
            int toughness = 0;
            for (Cost cost : source.getCosts()) {
                if (!(cost instanceof SacrificeTargetCost) || ((SacrificeTargetCost)cost).getPermanents().isEmpty()) continue;
                power = ((Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)).getPower().getValue();
                toughness = ((Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)).getToughness().getValue();
                break;
            }
            if (power > 0) {
                controller.drawCards(power, source, game);
            }
            if (toughness > 0) {
                controller.gainLife(toughness, game, source);
            }
            return true;
        }
        return false;
    }

    public MomentousFallEffect copy() {
        return new MomentousFallEffect(this);
    }
}

