/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetDiscard;

class MonomaniaEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("a card");

    MonomaniaEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player chooses a card in their hand and discards the rest";
    }

    private MonomaniaEffect(MonomaniaEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null || player.getHand().isEmpty()) {
            return false;
        }
        TargetDiscard target = new TargetDiscard(player.getId());
        player.choose(Outcome.Benefit, player.getHand(), (TargetCard)target, source, game);
        Cards cards = player.getHand().copy();
        cards.removeIf(target.getTargets()::contains);
        return !player.discard(cards, false, source, game).isEmpty();
    }

    public MonomaniaEffect copy() {
        return new MonomaniaEffect(this);
    }
}

